<?php

$maxImageSize = setting('_general.max_image_size');

return [
    'id'        => 'mission',
    'name'      => __('Mission'),
    'icon'      => '<i class="icon-globe"></i>',
    'tab'       => 'Common',
    'fields'    => [
        [
            'id'            => 'style_variation',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select style variation'),
            'options'       => [
                ''                              => __('Select style'),
                'am-mission-variation-one'      => __('Style V1'),
            ],
            'default'       => '',
            'placeholder'   => __('settings.select_from_list'),
        ],
        [
            'id'            => 'select_title_verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select title varient'),
            'options'       => [
                ''                            => 'Select title style',
                'am-title-varient-one'        => 'Title style v1',
            ],
            'default'       => '',  
            'placeholder'   => __('settings.select_from_list'),  
        ],
        [
            'id'            => 'pre_heading_text_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading text color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading_bg_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading bg color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre Heading'),
            'placeholder'   => __('Enter pre heading'),
        ],
        [
            'id'            => 'heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'paragraph',
            'type'          => 'editor',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Description'),
            'placeholder'   => __('Enter description'),
        ],
        [
            'id'                => 'list_data',
            'type'              => 'repeater',
            'label_title'       => __('List data'),
            'repeater_title'    => __('List data'),
            'multi'             => true,
            'fields'        => [
                [
                    'id'            => 'item_heading',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Item heading'),
                    'placeholder'   => __('Enter heading'),
                ],
                [
                    'id'            => 'list_item',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Item description'),
                    'placeholder'   => __('Enter item'),
                ],
            ]
        ],
        [
            'id'            => 'button_enabled',
            'type'          => 'radio',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Button enabled'),
            'options'       => [
                'yes'   => 'Yes',
                'no'    => 'No',
            ],
            'default'       => 'no',
        ],
        [
            'id'            => 'button_text',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Button text'),
            'placeholder'   => __('Enter button text'),
        ],
        [
            'id'            => 'button_url',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Button url'),
            'placeholder'   => __('Enter button url'),
        ],
        [
            'id'            => 'mission_frame_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Frame image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'user_one_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('First user image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'handshake_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'user_two_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Second user image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'image_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Image heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'courses_text',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Courses text'),
            'placeholder'   => __('Enter text'),
        ],
    ]
];
