<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dispute_conversations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dispute_id')->constrained('disputes');
            $table->foreignId('user_id')->constrained('users');
            $table->string('conversation_group');
            $table->text('message');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dispute_conversations');
    }
};
